<div class="container mt-4">
    <div class="card border-primary shadow">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0"><?= $title; ?></h4>
        </div>

        <div class="card-body">

            <table class="table table-bordered table-striped">
                <thead class="bg-primary text-white text-center">
                    <tr>
                        <th>No</th>
                        <th>ID Pembayaran</th>
                        <th>Metode Pembayaran</th>
                        <th>Status</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $no=1; foreach($pembayaran as $r): ?>
                    <tr class="text-center">
                        <td><?= $no++ ?></td>
                        <td><?= $r->id_pembayaran ?></td>
                        <td><?= $r->metode_pembayaran ?></td>
                        <td>
                            <?php if($r->status == 'Lunas'): ?>
                                <span class="badge bg-success">Lunas</span>
                            <?php else: ?>
                                <span class="badge bg-danger">Belum Bayar</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <button onclick="window.print()" class="btn btn-primary mt-3">
                Print Laporan
            </button>

        </div>
    </div>
</div>

<style>
/* Saat print tampil rapi, border tidak hilang */
@media print {
    .btn, .card-header { display: none !important; }

    .card { border: none; box-shadow: none; }
    
    .table-bordered {
        border: 1px solid #000 !important;
    }
    .table-bordered th, .table-bordered td {
        border: 1px solid #000 !important;
        color: #000 !important;
    }
}
</style>
