<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Sistem Pendataan Pelanggan Laundry</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">

<style>
*{
    margin:0;
    padding:0;
    box-sizing:border-box;
}

html,body{
    min-height:100vh;
    font-family:'Poppins',sans-serif;
}

/* ===== BACKGROUND BERWARNA + GAMBAR ===== */
body{
    background:
        linear-gradient(
            135deg,
            rgba(236,233,254,0.75),
            rgba(219,234,254,0.75),
            rgba(252,231,243,0.75)
        ),
        url("https://images.unsplash.com/photo-1626806787461-102c1bfaaea1?q=80&w=1920");
    background-size:cover;
    background-position:center;
    background-repeat:no-repeat;
    background-attachment:fixed;
}

/* ===== HEADER ===== */
header{
    text-align:center;
    padding:120px 20px 70px;
}

header h1{
    font-size:30px;
    font-weight:700;
    background:linear-gradient(135deg,#7c3aed,#ec4899,#3b82f6);
    -webkit-background-clip:text;
    -webkit-text-fill-color:transparent;
    margin-bottom:16px;
}

header p{
    max-width:760px;
    margin:auto;
    font-size:15px;
    line-height:1.9;
    color:#374151;
}

/* ===== MENU ===== */
.menu{
    width:90%;
    margin:40px auto 90px;
    display:grid;
    grid-template-columns:repeat(3,1fr);
    gap:30px;
}

.card{
    background:
        linear-gradient(
            135deg,
            rgba(255,255,255,0.85),
            rgba(243,244,246,0.85)
        );
    border-radius:22px;
    padding:36px 22px;
    text-align:center;
    box-shadow:0 20px 45px rgba(0,0,0,0.15);
    transition:.35s;
    border:1px solid rgba(255,255,255,0.6);
}

.card:hover{
    transform:translateY(-8px);
    box-shadow:0 35px 70px rgba(124,58,237,0.35);
}

.icon{
    font-size:44px;
    margin-bottom:12px;
}

.card h3{
    font-size:18px;
    margin-bottom:6px;
    color:#1f2937;
}

.card p{
    font-size:14px;
    color:#6b7280;
}

.card a{
    display:inline-block;
    margin-top:16px;
    padding:10px 30px;
    background:linear-gradient(135deg,#7c3aed,#ec4899);
    color:#fff;
    border-radius:999px;
    text-decoration:none;
    font-size:13px;
    box-shadow:0 12px 30px rgba(236,72,153,0.4);
}

/* ===== FOOTER ===== */
footer{
    text-align:center;
    padding:28px;
    font-size:13px;
    color:#374151;
}

/* ===== RESPONSIVE ===== */
@media(max-width:900px){
    .menu{grid-template-columns:repeat(2,1fr)}
}
@media(max-width:600px){
    .menu{grid-template-columns:1fr}
    header h1{font-size:24px}
}
</style>
</head>

<body>

<header>
    <h1>Sistem Pendataan Pelanggan Laundry</h1>
    <p>
        Sistem pendataan pelanggan laundry yang dirancang dengan tampilan
        modern, berwarna, dan aesthetic untuk memudahkan pengelolaan data
        pelanggan, transaksi, pembayaran, serta pengeluaran.
    </p>
</header>

<section class="menu">
    <div class="card">
        <div class="icon">🙂</div>
        <h3>Data Pelanggan</h3>
        <p>Pendataan pelanggan</p>
        <a href="<?= base_url('pelanggan'); ?>">Masuk</a>
    </div>

    <div class="card">
        <div class="icon">🧼</div>
        <h3>Paket Laundry</h3>
        <p>Layanan & harga</p>
        <a href="<?= base_url('paket_laundry'); ?>">Masuk</a>
    </div>

    <div class="card">
        <div class="icon">👕</div>
        <h3>Pegawai</h3>
        <p>Data pegawai</p>
        <a href="<?= base_url('pegawai'); ?>">Masuk</a>
    </div>

    <div class="card">
        <div class="icon">📦</div>
        <h3>Transaksi</h3>
        <p>Data transaksi</p>
        <a href="<?= base_url('transaksi'); ?>">Masuk</a>
    </div>

    <div class="card">
        <div class="icon">💳</div>
        <h3>Pembayaran</h3>
        <p>Riwayat pembayaran</p>
        <a href="<?= base_url('pembayaran'); ?>">Masuk</a>
    </div>

    <div class="card">
        <div class="icon">💰</div>
        <h3>Pengeluaran</h3>
        <p>Biaya operasional</p>
        <a href="<?= base_url('pengeluaran'); ?>">Masuk</a>
    </div>
</section>

<footer>
    © <?= date('Y'); ?> Sistem Pendataan Pelanggan Laundry
</footer>

</body>
</html>
