<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class transaksi extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('M_transaksi');
	}

	public function index()
	{
		$data['title']= 'Manajemen Data Transaksi';
		$data['transaksi']= $this->M_transaksi->tampil_data()->result_array();

		$this->load->view('v_header',$data);
		$this->load->view('transaksi/v_data_transaksi', $data);
		$this->load->view('v_footer');
	}
	
	function tambah(){
		$data['title']= 'Tambah Data Transaksi';

		$this->load->view('v_header',$data);
		$this->load->view('transaksi/v_add_transaksi');
		$this->load->view('v_footer');
	}

	function insert(){
		$id_transaksi = $this->input->post('id_transaksi');
		$id_pelanggan = $this->input->post('id_pelanggan');
		$id_paket = $this->input->post('id_paket');
		$berat_kg = $this->input->post('berat_kg');
		$total_harga = $this->input->post('total_harga');
		$tanggal = $this->input->post('tanggal');
        $status = $this->input->post('status');

		$data = array(
			'id_transaksi' => $id_transaksi,
			'id_pelanggan' => $id_pelanggan,
			'id_paket' => $id_paket,
			'berat_kg' => $berat_kg,
			'total_harga' => $total_harga,
			'tanggal' => $tanggal,
            'status' => $status
		);

		$this->m_transaksi->insert_data($data);
		redirect('transaksi');
	}

	function edit($id){
		$data['title']= 'Ubah Data Transaksi';

		$where = array('id_transaksi' => $id); 
		$data['r']= $this->m_transaksi->edit_data($where)->row_array();

		$this->load->view('v_header',$data);
		$this->load->view('transaksi/v_edit_transaksi', $data);
		$this->load->view('v_footer');
	}

	function update(){
		$id = $this->input->post('id');
		$id_transaksi = $this->input->post('id_transaksi');
		$id_pelanggan = $this->input->post('id_pelanggan');
		$id_paket = $this->input->post('id_paket');
		$berat_kg = $this->input->post('berat_kg');
		$total_harga = $this->input->post('total_harga');
		$tanggal = $this->input->post('tanggal');
        $status = $this->input->post('status');

		$data = array(
			'id_transaksi' => $id_transaksi,
			'id_pelanggan' => $id_pelanggan,
			'id_paket' => $id_paket,
			'berat_kg' => $berat_kg,
			'total_harga' => $total_harga,
			'tanggal' => $tanggal,
            'status' => $status
		);

		$where = array('id_transaksi' => $id);
		$this->m_transaksi->update_data($data, $where);

		redirect('transaksi');
	}

	function hapus($id){
		$where = array('id_transaksi' => $id);
		$this->m_transaksi->hapus_data($where);
		redirect('transaksi');
	}
}
