<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class pelanggan extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('M_pelanggan');
	}

	public function index()
	{
		$data['title']= 'Manajemen Data pelanggan';
		$data['pelanggan']= $this->M_pelanggan->tampil_data()->result_array();

		$this->load->view('v_header',$data);
		$this->load->view('pelanggan/v_data_pelanggan', $data);
		$this->load->view('v_footer');
	}
	
	function tambah(){
		$data['title']= 'Tambah Data pelanggan';

		$this->load->view('v_header',$data);
		$this->load->view('pelanggan/v_add_pelanggan');
		$this->load->view('v_footer');
	}

	function insert(){
		$id_pelanggan = $this->input->post('id_pelanggan');
		$nama_pelanggan = $this->input->post('nama_pelanggan');
		$alamat = $this->input->post('alamat');
		$no_telp = $this->input->post('no_telp');
		$tanggal_daftar = $this->input->post('tanggal_daftar');

		$data = array(
			'id_pelanggan' => $id_pelanggan,
			'nama_pelanggan' => $nama_pelanggan,
			'alamat' => $alamat,
			'no_telp' => $no_telp,
			'tanggal_daftar' => $tanggal_daftar
		);

		$this->m_pelanggan->insert_data($data);
		redirect('pelanggan');
	}

	function edit($id){
		$data['title']= 'Ubah Data pelanggan';

		$where = array('id_pelanggan' => $id);
		$data['r']= $this->m_pelanggan->edit_data($where)->row_array();

		$this->load->view('v_header',$data);
		$this->load->view('pelanggan/v_edit_pelanggan', $data);
		$this->load->view('v_footer');
	}

	function update(){
		$id = $this->input->post('id');
		$id_pelanggan = $this->input->post('id_pelanggan');
		$nama_pelanggan = $this->input->post('nama_pelanggan');
		$alamat = $this->input->post('alamat');
		$no_telp = $this->input->post('no_telp');
		$tanggal_daftar = $this->input->post('tanggal_daftar');

		$data = array(
			'id_pelanggan' => $id_pelanggan,
			'nama_pelanggan' => $nama_pelanggan,
			'alamat' => $alamat,
			'no_telp' => $no_telp,
			'tanggal_daftar' => $tanggal_daftar
		);

		$where = array('id_pelanggan' => $id);
		$this->m_pelanggan->update_data($data, $where);

		redirect('pelanggan');
	}

	function hapus($id){
		$where = array('id_pelanggan' => $id);
		$this->m_pelanggan->hapus_data($where);
		redirect('pelanggan');
	}

}
