<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pegawai extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('M_pegawai');
	}

	public function index()
	{
		$data['title']= 'Manajemen Data Pegawai';
		$data['pegawai']= $this->M_pegawai->tampil_data()->result_array();

		$this->load->view('v_header',$data);
		$this->load->view('pegawai/v_data_pegawai', $data);
		$this->load->view('v_footer');
	}
	
	function tambah(){
		$data['title']= 'Tambah Data Pegawai';

		$this->load->view('v_header',$data);
		$this->load->view('pegawai/v_add_pegawai');
		$this->load->view('v_footer');
	}

	function insert(){
		$id_pegawai 	 = $this->input->post('id_pegawai');
		$nama 			 = $this->input->post('nama');
		$jabatan 		 = $this->input->post('jabatan');
		$no_telp 			 = $this->input->post('no_telp');      // ← SUDAH BENAR
		$tanggal_masuk   = $this->input->post('tanggal_masuk'); // ← SUDAH BENAR

		$data = array(
			'id_pegawai'   => $id_pegawai,
			'nama'         => $nama,
			'jabatan'      => $jabatan,
			'no_telp'        => $no_telp,
			'tanggal_masuk'=> $tanggal_masuk,
		);

		$this->m_pegawai->insert_data($data);
		redirect('pegawai');
	}

	function edit($id){
		$data['title']= 'Ubah Data Pegawai';

		$where = array('id_pegawai' => $id);
		$data['r']= $this->m_pegawai->edit_data($where)->row_array();

		$this->load->view('v_header',$data);
		$this->load->view('pegawai/v_edit_pegawai', $data);
		$this->load->view('v_footer');
	}

	function update(){
		$id 			 = $this->input->post('id');
		$id_pegawai 	 = $this->input->post('id_pegawai');
		$nama 			 = $this->input->post('nama');
		$jabatan 		 = $this->input->post('jabatan');
		$no_telp 			 = $this->input->post('no_telp');
		$tanggal_masuk   = $this->input->post('tanggal_masuk');

		$data = array(
			'id_pegawai'   => $id_pegawai,
			'nama'         => $nama,
			'jabatan'      => $jabatan,
			'no_telp'        => $no_telp,
			'tanggal_masuk'=> $tanggal_masuk,
		);

		$where = array('id_pegawai' => $id);
		$this->m_pegawai->update_data($data, $where);

		redirect('pegawai');
	}

	function hapus($id){
		$where = array('id_pegawai' => $id);
		$this->m_pegawai->hapus_data($where);
		redirect('pegawai');
	}

}
